/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_4286;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GameOption<T> {
    private final class_2561 title;
    private final class_2561 description;
    @Nullable
    Consumer<T> consumer;
    private byte value;

    public GameOption(T value, class_2561 title, class_2561 description) {
        this.value = this.toByte(value);
        this.title = title;
        this.description = description;
    }

    protected abstract byte toByte(T var1);

    protected abstract T fromByte(byte var1);

    public class_2561 getTitle() {
        return this.title;
    }

    public class_2561 getDescription() {
        return this.description;
    }

    public T get() {
        return this.fromByte(this.value);
    }

    public void set(T value) {
        this.value = this.toByte(value);
        if (this.consumer != null) {
            this.consumer.accept(value);
        }
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(byte value) {
        this.value = value;
        if (this.consumer != null) {
            this.consumer.accept(this.get());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public abstract Widget getWidget(Consumer<T> var1, class_327 var2, int var3, int var4, boolean var5);

    public static class Number
    extends GameOption<Integer> {
        private final int min;
        private final int max;

        public Number(int value, int min, int max, class_2561 title, class_2561 description) {
            super(value, title, description);
            this.min = min;
            this.max = max;
        }

        @Override
        protected byte toByte(Integer value) {
            return value.byteValue();
        }

        @Override
        protected Integer fromByte(byte value) {
            return value;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public Widget getWidget(Consumer<Integer> consumer, class_327 font, int width, int height, final boolean showcase) {
            final Function<Integer, class_2561> message = i -> this.getTitle().method_27661().method_27693(": ").method_27693(Integer.toString(i));
            class_357 slider = new class_357(0, 0, width, height, message.apply((Integer)this.get()), (double)((Integer)this.get()).intValue() * (1.0 / (double)(this.max - this.min))){
                private static final class_2960 SLIDER_HANDLE_SPRITE = class_2960.method_60656((String)"widget/slider_handle");

                @NotNull
                public class_2960 method_52717() {
                    return showcase ? SLIDER_HANDLE_SPRITE : super.method_52717();
                }

                protected void method_25346() {
                    this.method_25355((class_2561)message.apply((Integer)this.get()));
                }

                protected void method_25344() {
                    this.set(class_3532.method_15357((double)class_3532.method_16436((double)this.field_22753, (double)min, (double)max)));
                }

                protected void method_49604(@NotNull class_332 guiGraphics, @NotNull class_327 font, int width, int color) {
                    super.method_49604(guiGraphics, font, width, 0xFFFFFF | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
                }
            };
            slider.method_47400(class_7919.method_47407((class_2561)this.getDescription()));
            this.consumer = i -> {
                slider.method_25347((double)i.intValue() * (1.0 / (double)(this.max - this.min)));
                consumer.accept((Integer)i);
            };
            slider.field_22763 = !showcase;
            return new Widget((class_339)slider);
        }
    }

    public static class Bool
    extends GameOption<Boolean> {
        public Bool(boolean value, class_2561 title, class_2561 description) {
            super(value, title, description);
        }

        @Override
        protected byte toByte(Boolean value) {
            return value != false ? (byte)1 : 0;
        }

        @Override
        protected Boolean fromByte(byte value) {
            return value == 1;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public Widget getWidget(Consumer<Boolean> consumer, class_327 font, int width, int height, boolean showcase) {
            class_4286.class_8929 builder = class_4286.method_54787((class_2561)this.getTitle(), (class_327)font);
            builder.method_54793(class_7919.method_47407((class_2561)this.getDescription()));
            builder.method_61131(width);
            builder.method_54794(((Boolean)this.get()).booleanValue());
            builder.method_54791((checkbox, value) -> this.set(value));
            class_4286 checkbox2 = builder.method_54788();
            this.consumer = b -> {
                if (b.booleanValue() != checkbox2.method_20372()) {
                    checkbox2.method_25306();
                }
                consumer.accept((Boolean)this.get());
            };
            checkbox2.field_22763 = !showcase;
            return new Widget((class_339)checkbox2);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Widget
    extends class_4265.class_4266<Widget> {
        private final class_339 widget;

        public Widget(class_339 widget) {
            this.widget = widget;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return List.of(this.widget);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return List.of(this.widget);
        }

        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.widget.method_46421(left);
            this.widget.method_46419(top);
            this.widget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }

        @Nullable
        public class_7919 getTooltip() {
            return this.widget.method_51254();
        }

        public void setTooltip(@Nullable class_7919 tooltip) {
            this.widget.method_47400(tooltip);
        }
    }
}

